Imports System.IO

Public Class LoaderClass
  Implements IDisposable
  
  Private FFileName As String
  Private FReader As TextReader
  Private FArrayList As ArrayList
  Public Event OnText(ByVal Text As String)

  Private Sub DoText(ByVal Text As String)
    RaiseEvent OnText(Text)
  End Sub

  Public Property FileName() As String
    Get
      Return FFileName
    End Get
    Set(ByVal Value As String)
      FFileName = Value
    End Set
  End Property

  Public Overloads Sub Open()
    If (FReader Is Nothing) Then
      FReader = File.OpenText(FFileName)
    Else
      Throw New ApplicationException("file is already open")
    End If
  End Sub

  Public Overloads Sub Open(ByVal AFileName As String)
    FileName = AFileName
    Open()
  End Sub

  Public Sub Close()
    If (FReader Is Nothing) Then Exit Sub
    FReader.Close()
    FReader = Nothing
  End Sub

  Private Function Add(ByVal Text As String) As Boolean
    If (Text = "") Then Return False
    DoText(Text)
    FArrayList.Add(Text)
    Return True
  End Function

  Private Function Reading() As Boolean
    Return Not FDisposed AndAlso Add(FReader.ReadLine())
  End Function

  Public Sub Load()
    While (Reading())
      Application.DoEvents()
    End While
  End Sub

  Public Sub New()
    MyBase.New()
    FArrayList = New ArrayList()
  End Sub

  Public Sub New(ByVal AFileName As String)
    Me.New()
    FileName = AFileName
  End Sub

  Private FDisposed As Boolean = False

  Public Sub Dispose() Implements IDisposable.Dispose
    If (FDisposed) Then Exit Sub
    FDisposed = True
    Close()
    FArrayList = Nothing
  End Sub

  Protected Overrides Sub Finalize()
    Dispose()
    MyBase.Finalize()
  End Sub

  Public Shared Function Load(ByVal AFileName _
    As String) As LoaderClass

    Dim ALoader As New LoaderClass(AFileName)
    ALoader.Open()
    ALoader.Load()
    Return ALoader

  End Function
End Class
